/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.game;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.blockentity.CardTableBlockEntity;
import dev.lucaargolo.charta.blockentity.ModBlockEntityTypes;
import dev.lucaargolo.charta.game.AutoPlayer;
import dev.lucaargolo.charta.game.CardDeck;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.game.CardPlayer;
import dev.lucaargolo.charta.game.GameOption;
import dev.lucaargolo.charta.game.crazyeights.CrazyEightsGame;
import dev.lucaargolo.charta.game.fun.FunGame;
import dev.lucaargolo.charta.game.solitaire.SolitaireGame;
import dev.lucaargolo.charta.mixed.LivingEntityMixed;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_3914;
import org.jetbrains.annotations.Nullable;

public class CardGames {
    private static final Map<class_2960, Factory<?>> factories = new HashMap();
    public static final Factory<CrazyEightsGame> CRAZY_EIGHTS = CardGames.register(Charta.id("crazy_eights"), CrazyEightsGame::new);
    public static final Factory<FunGame> FUN = CardGames.register(Charta.id("fun"), FunGame::new);
    public static final Factory<SolitaireGame> SOLITAIRE = CardGames.register(Charta.id("solitaire"), SolitaireGame::new);

    public static <G extends CardGame<G>> Factory<G> register(class_2960 location, Factory<G> factory) {
        if (factories.containsKey(location)) {
            throw new IllegalArgumentException("Duplicate key: " + String.valueOf(location));
        }
        factories.put(location, factory);
        return factory;
    }

    public static Map<class_2960, Factory<?>> getGames() {
        return factories;
    }

    @Nullable
    public static Factory<?> getGame(class_2960 gameId) {
        return factories.get(gameId);
    }

    public static class_2960 getGameId(Factory<?> factory) {
        return factories.entrySet().stream().filter(entry -> entry.getValue() == factory).map(Map.Entry::getKey).findFirst().orElse(Charta.MISSING_GAME);
    }

    public static <G extends CardGame<G>> G getGameForMenu(Factory<G> factory, class_3914 access, CardDeck deck, int[] players, byte[] options) {
        try {
            return (G)access.method_17395((level, pos) -> (CardTableBlockEntity)((Object)((Object)level.method_35230(pos, ModBlockEntityTypes.CARD_TABLE).get()))).map(table -> table.getGame()).get();
        }
        catch (Exception e) {
            ArrayList<CardPlayer> cardPlayers = new ArrayList<CardPlayer>();
            for (int entityId : players) {
                CardPlayer player = access.method_17395((level, pos) -> {
                    class_1297 entity;
                    if (entityId >= 0 && (entity = level.method_8469(entityId)) instanceof LivingEntityMixed) {
                        LivingEntityMixed mixed = (LivingEntityMixed)entity;
                        return mixed.charta_getCardPlayer();
                    }
                    return new AutoPlayer(1.0f);
                }).orElse(new AutoPlayer(1.0f));
                cardPlayers.add(player);
            }
            G game = factory.create(cardPlayers, deck);
            ((CardGame)game).setRawOptions(options);
            return game;
        }
    }

    public static <G extends CardGame<G>> boolean areOptionsChanged(Factory<G> factory, G game) {
        G defaultGame = factory.create(List.of(), CardDeck.EMPTY);
        for (int i = 0; i < ((CardGame)defaultGame).getOptions().size(); ++i) {
            GameOption<?> defaultOption = ((CardGame)defaultGame).getOptions().get(i);
            GameOption<?> modifiedOption = game.getOptions().get(i);
            if (modifiedOption.getValue() == defaultOption.getValue()) continue;
            return true;
        }
        return false;
    }

    @FunctionalInterface
    public static interface Factory<G extends CardGame<G>> {
        public G create(List<CardPlayer> var1, CardDeck var2);
    }
}

